<?php
namespace App\Http\Controllers;
use App\Models\User;
use App\Models\SecurityPin;
use Illuminate\Http\Request;
use Carbon\Carbon;

class SecurityPinController extends Controller
{
    public function index()
    {
        $user = auth()->user(); // Get the logged-in user
        $pin = $user->securityPin; // Retrieve the user's security pin if exists

        return view('security_pin.index', compact('pin'));
    }

public function store()
{
    \Log::info('Attempting to generate pin...');

    $user = auth()->user(); // Get the logged-in user

    // Generate a random 4-digit pin
    $pin = rand(1000, 9999);
    \Log::info('Generated Pin: ' . $pin);

    // Store the pin with the user and set expiration time
    $user->securityPin()->create([
        'pin' => $pin,
        'expires_at' => Carbon::now()->addHours(2), // Adjust expiration time as needed
    ]);

    \Log::info('Pin stored successfully.');

    return redirect()->route('security.pin.index')->with('success', 'Security pin generated successfully.');
}

    public function reset()
    {
        $user = auth()->user(); // Get the logged-in user

        // Delete the current pin if exists
        if ($user->securityPin) {
            $user->securityPin->delete();
        }

        return redirect()->route('security.pin.index')->with('success', 'Security pin reset successfully.');
    }
}
